"""Test a tarfile matches a set of globs"""
from fussy import nbio
from .sixish import as_unicode


def is_gzipped(filename):
    with open(filename, 'rb') as fh:
        header = fh.read(2)
        if header == b'\x1f\x8b':
            return True
        else:
            return False


def tar_list(tarfile):
    """List the files in a tarfile"""
    flags = '-tf'
    if is_gzipped(tarfile):
        flags = '-ztf'
    return as_unicode(nbio.Process(['tar', '-tf', tarfile])()).splitlines()


def find_pattern(files, pattern):
    for file in files:
        if pattern.match(file):
            return file
    return False


def tar_match(tarfile, patterns):
    """Ensure that each pattern in patterns is found in tarfile"""
    files = tar_list(tarfile)
    for pattern in patterns:
        if not find_pattern(files, pattern):
            return False
    return True
