from django.core.serializers import serialize
from django.template import Library
from django.utils.safestring import mark_safe
import urllib

register = Library()

@register.inclusion_tag('filtermodel/exact.html')
def filter_exact( field, value, request, **named ):
    return {
        'filter_url': request.filtermodel_url,
        'field': field,
        'value': value,
        'request': request,
        'next': request.get_full_path(),
    }
@register.inclusion_tag('filtermodel/range.html')
def filter_ranges( field, value, request, **named ):
    return {
        'filter_url': request.filtermodel_url,
        'field': field,
        'value': value,
        'request': request,
        'next': request.get_full_path(),
    }

@register.inclusion_tag('filtermodel/search.html')
def filter_search( field, request, **named ):
    return {
        'filter_url': request.filtermodel_url,
        'field': field,
        'request': request,
        'next': request.get_full_path(),
    }

@register.inclusion_tag('filtermodel/sort.html')
def filter_sort( field, request, **named ):
    current = None
    if request.filtermodel_current:
        if field in request.filtermodel_current.get('sort',())[:1]:
            current = 'up'
        elif '-'+field in request.filtermodel_current.get('sort',())[:1]:
            current = 'down'
    return {
        'filter_url': request.filtermodel_url,
        'sorting_up': current == 'up',
        'sorting_down': current == 'down',
        'up_field': field,
        'down_field': '-'+field,
        'field': field,
        'request': request,
        'next': request.get_full_path(),
    }
