from atxstyle.sixish import unicode
from django.template import Library
from django.utils.safestring import mark_safe
import time
from atxstyle import utctime

register = Library()

@register.filter
def timestamp(object, timezone=None):
    if object is None:
        object = time.time()
    if isinstance( object, (bytes,unicode)):
        try:
            object = float( object )
        except Exception:
            return object
    dt = utctime.from_timestamp( object, timezone or utctime.UTC )
    return mark_safe(
        dt.strftime( '%Y-%m-%d&nbsp;%H:%M:%S %Z')
    )
