#! /usr/bin/env python
import psutil, sys, time
def main():
    programs = [
        int(x) for x in sys.argv[1:]
    ]
    delay = .1
    count = 600
    history = [[] for program in programs]
    current = [[] for program in programs]
    while True:
        for p,c,h in zip(programs,current,history):
            try:
                c.append(psutil.Process(p).memory_info().rss)
            except Exception:
                c.append(0)
            if len(c) >= count:
                h.append( min(c))
                del c[:]
                print( '')
                print( '%s %s'%( p, ' '.join(['%0.3f'%(v/(1024.*1024.)) for v in h])))
            else:
                if not len(c) % 60:
                    sys.stdout.write('.')
                    sys.stdout.flush()
        time.sleep(delay)
    
if __name__ == "__main__":
    main()
    
