from __future__ import absolute_import

from atxstyle.sixishdj import url, include
from django.contrib.auth import models
from django.views.generic import list

from atxstyle import users, views as atxstyle_views, reactforms as reactforms_views


class UserView(list.ListView):
    queryset = models.User.objects.order_by('username')


urlpatterns = [
    url(r'^$', users.users, name='users'),
    url(r'^new/$', users.edit, name='user'),
    url(r'^(?P<user>\d+)/$', users.edit, name='user'),
    url(r'^(?P<user>\d+)/delete/$', users.user_delete, name='user_delete'),
    url(r'^', include('atxstyle.user_api_urls')),
]
