from atxstyle import defaultsettings
defaultsettings.setup_default()
import json, logging, os
from fussy import twrite
from atxstyle import models
from django.conf import settings
from django.core.exceptions import AppRegistryNotReady
import argparse
log = logging.getLogger(__name__)

def write(
    target=os.path.join( settings.RUN_DIRECTORY, 'device-status.json' ),
    dry_run=False,
    system=None
):
    try:
        system = system or models.System.get_current()
    except AppRegistryNotReady:
        log.info("Running during migrations, ignoring not-initialized registry")
        return 0
    content = system.schedule_json()
    linearized = json.dumps( content, indent=2 )
    if dry_run:
        log.info("Skipping writing, contents follow")
        print( linearized )
    else:
        twrite.twrite( target, linearized )

def main(*args,**named):
    """Write out status to be consumed by snmp device daemon"""
    logging.basicConfig( level = logging.INFO )

    parser = argparse.ArgumentParser(
        description='Write Device Status information for the product'
    )
    parser.add_argument(
        '-d','--dry-run',
        action='store_true',
        default = False,
        help = "Do not attempt to write/restart, just print the config",
    )
    options = parser.parse_args()
    write(dry_run=options.dry_run)
    return 0
