from django.conf import settings
try:
    from django.contrib import admin
except ImportError as err:
    admin = None 
else:
    from epgfetch import models 

    class DataSourceAdmin( admin.ModelAdmin ):
        """Admin class"""
        if settings.INCLUDE_TW_FEED:
            list_display = [
                'pk',
                'format',
                'division',
                'production',
                'user',
                'preferred_download',
                'last_download_formatted',
            ]
        else:
            list_display = [
                'pk',
                'format',
                'user',
                'url',
                'preferred_download',
                'last_download_formatted',
            ]
    admin.site.register( models.DataSource, DataSourceAdmin )
    
    if settings.INCLUDE_TW_FEED:
        class LineupAdmin( admin.ModelAdmin ):
            """Lineup managementment"""
            list_display = [
                'name',
                'division',
                'lineup',
                'wanted_formatted',
                'active',
            ]
        admin.site.register( models.Lineup, LineupAdmin )
    
#    from django.contrib.gis import admin as gis_admin
#    #admin.site.register( models.ServerLocation, gis_admin.OSMGeoAdmin )
#    admin.site.register( models.ServerLocation, gis_admin.GeoModelAdmin )
    
