"""Downloading/updating pod for use in shogun"""
from atxstyle import defaultsettings

defaultsettings.setup_default()
import time, logging
from fussy import nbio
from django.db import transaction
from epgfetch import models
from epgconfig import models as epg_models

log = logging.getLogger(__name__)


def get_options():
    import argparse

    parser = argparse.ArgumentParser(
        description='Pull atxlicense and epgfetch data from upstream'
    )
    parser.add_argument(
        '-l',
        '--loop',
        default=False,
        action='store_true',
        help='If specified run a foreground loop pulling the records every day',
    )
    return parser


@transaction.atomic()
def cycle():
    nbio.Process(['license-pull'])()
    for ds in models.DataSource.objects.all():
        ds.download_stations()
    for epg in epg_models.EPG.objects.all():
        epg.pull_schedule_data()


def main():
    options = get_options().parse_args()
    if options.loop:
        last = 0
        while True:
            if time.time() - last > 3600:
                try:
                    cycle()
                    last = time.time()
                except Exception as err:
                    log.exception('Failure during license pull')
                    time.sleep(10 * 60)
            time.sleep(60)
    else:
        cycle()
