"""aiohttp based epg dataserver stand-alone client"""
import aiohttp, typing, logging, time, os

log = logging.getLogger(__name__)


async def cache_callback(
    tmsid, fetch, cache, expire, timestamp=time.time
) -> typing.Optional[dict]:
    """Cache miss, so get our cached data

    Does a cache current and then
    """
    async with aiohttp.ClientSession(
        connector=aiohttp.TCPConnector(ssl=False)
    ) as session:
        response = await session.post(
            fetch['url'],
            data={
                'key': fetch['key'],
                'tmsids': [tmsid],
            },
            headers={
                'CLUSTER-LOCAL-HOST-MARKER': os.environ.get('CLUSTER_LOCAL_HOST_MARKER',''),
            },
        )
        if response.status == 200:
            content = await response.json()
            # TODO: set to desired-download-time delta?
            if content.get('success'):
                # log.debug('Caching schedule for TMSID %s', tmsid)
                # store metadata for bookkeeping/debugging
                content['tmsid'] = tmsid
                content['url'] = fetch['url']
                content['ts'] = timestamp()
                return content
            else:
                log.warning(
                    'Schedule TMSID=%s download error: %s',
                    tmsid,
                    content,
                )
        else:
            log.warning(
                'Schedule TMSID=%s download failure: %s',
                tmsid,
                response.status,
            )
    return None
