from atxstyle.sixishdj import gettext_lazy as _

assert _
import logging
from django.conf import settings

from atxstyle.forms import AlwaysValidate
from atxstyle import ownership

from epgfetch import models

TW_FEED = getattr(settings, 'INCLUDE_TW_FEED', False)
TW_CLIENT = getattr(settings, 'INCLUDE_TW_CLIENT', False)

log = logging.getLogger(__name__)


class DataSourceForm(AlwaysValidate):
    class Meta:
        model = models.DataSource
        fields = [
            'name',
            'owner',
            'format',
            'url',
            'user',
            'password',
            'account_number',
            'account_name',
            'account_address',
            'smartbox_serial_number',
            'preferred_download',
        ]

    def clean_url(self):
        value = self.cleaned_data.get('url')
        if value:
            return value.strip()
        return value

    display_notes = {
        'format__' + models.DataSource.DISH: "Only locations which have a Dish Network video feed provided by a SmartBox can use this guide data, the information entered into the following boxes will be shared with Dish Network, if it is found that this location does not have a dish supplied video feed then all Set Back Boxes on that Account will lose access to the Dish provided Guide data",
    }
    
    dependencies = {
        ('format__ne', models.DataSource.DISH): ['user', 'password', 'url'],
        ('format__ne', models.DataSource.ROVI): [
            'smartbox_serial_number',
        ],
        ('format__ne', models.DataSource.DSI): [
            'account_number',
            'account_name',
            'account_address',
            'smartbox_serial_number',
        ],
        ('format__ne', models.DataSource.ZAP2IT): [
            'user',
            'password',
            'url',
            'preferred_download',
            'account_number',
            'account_name',
            'account_address',
            'smartbox_serial_number',
        ],
        ('format__ne', models.DataSource.EPG_DATA): [
            'account_number',
            'account_name',
            'account_address',
            'smartbox_serial_number',
        ],
        ('format__ne', models.DataSource.TRIBUNE): [
            'account_number',
            'account_name',
            'account_address',
            'smartbox_serial_number',
        ],
        ('format__ne', models.DataSource.NSPEI): [
            'account_number',
            'account_name',
            'account_address',
            'smartbox_serial_number',
        ],
    }
    permissions = ['epgfetch.configure']
    view_permissions = ['epgfetch.view']
    needs_user = True

    def __init__(self, *args, **named):
        self.user = named.pop('user')
        super(DataSourceForm, self).__init__(*args, **named)
        ownership.form_field_filter_owner(self, self.user)
        self.fields['url'].required = False


if TW_FEED:

    class TWDataSourceForm(AlwaysValidate):
        class Meta:
            model = models.DataSource
            fields = [
                'format',
                'user',
                'password',
                'division',
                'production',
                'preferred_download',
                'retire',
            ]

        def __init__(self, *args, **named):
            super(TWDataSourceForm, self).__init__(*args, **named)
            self.fields['user'].required = True
            self.fields['user'].label = 'API Key'
            self.fields['password'].required = True
            self.fields['password'].label = 'API Secret'
            if (
                self.instance
                and self.instance.format != models.DataSource.TIME_WARNER_API
            ):
                del self.fields['division']
            if (
                self.instance
                and self.instance.format == models.DataSource.TIME_WARNER_API
            ) and models.DataSource.objects.filter(
                format=models.DataSource.TIME_WARNER_API2
            ).count():
                pass
            else:
                del self.fields['retire']


if TW_CLIENT:

    class TWDataSourceForm(AlwaysValidate):
        class Meta:
            model = models.DataSource
            fields = [
                'url',
            ]

        def clean_url(self):
            value = self.cleaned_data.get('url')
            if value:
                return value.strip()
            return value

        def __init__(self, *args, **named):
            super(TWDataSourceForm, self).__init__(*args, **named)
            # self.fields['division'].help = _("Override the default division in the data-source")


from atxstyle.sixishdj import gettext as _

assert _
