# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.core.validators
import epgfetch.models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DataSource',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('format', models.CharField(default='dsi', help_text='Format for your data-source, normally this is MSO-specific', max_length=8, verbose_name='Feed Format', choices=[('rovi', 'ROVI (CSV)'), ('dsi', 'DSI International (XML)'), ('nspei', 'NS PEI (TVL)'), ('epgdata', 'EPG Data Server (JSON)')])),
                ('url', models.CharField(help_text='Full URL in standard format which defines the resource to be accessed', max_length=255, verbose_name='Feed URL', validators=[epgfetch.models.validate_url])),
                ('user', models.CharField(help_text='Username/API-key to access the resource', max_length=64, null=True, verbose_name='Feed Username', blank=True)),
                ('password', models.CharField(help_text='Password/Secret to access the resource', max_length=64, null=True, verbose_name='Feed Password', blank=True)),
                ('division', models.CharField(help_text='Time Warner Division code available on the configured server', max_length=64, null=True, verbose_name='TW API Division Code', blank=True)),
                ('production', models.BooleanField(default=True, help_text='Whether to use the production API/servers to service the request', verbose_name='Use Production Servers')),
                ('preferred_download', models.CharField(default='02:00', help_text='Time of day (HH:MM) at which to download (note, will run at the next hourly cron after this time)', max_length=5, verbose_name='Download Time', validators=[django.core.validators.RegexValidator('[0-9]?[0-9][:][0-9]{2}', message='Require a time-of-day in HH:MM (24-hour) format')])),
            ],
            options={
                'ordering': ['url', 'id'],
            },
        ),
        migrations.CreateModel(
            name='Lineup',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('division', models.CharField(max_length=10, verbose_name='Division', db_index=True)),
                ('lineup', models.CharField(max_length=10, verbose_name='Lineup', db_index=True)),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('wanted', models.FloatField(default=0.0, verbose_name='Wanted')),
                ('active', models.BooleanField(default=True, verbose_name='Active')),
                ('last_failure', models.BooleanField(default=False, verbose_name='Last Fail')),
                ('last_failure_log', models.TextField(verbose_name='Last Fail Log', null=True, editable=False, blank=True)),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='lineup',
            unique_together=set([('division', 'lineup')]),
        ),
    ]
