"""Makes sure django.conf.settings has our default settings unless overridden"""
from django.conf import settings
import os

SETTINGS_DEFAULTS = {
    'EPG_SCHEDULE_FILE_TEMPLATE': os.path.join('epg', '%(id)s', 'epg.json'),
    'EPG_STATION_FILES': os.path.join(settings.PROTECTED_DIR, 'stations', '%s.json'),
    'EPG_SOURCE_FILE': os.path.join(settings.PROTECTED_DIR, 'dataserver.url'),
    'INCLUDE_TW_FEED': False,
    'INCLUDE_TW_CLIENT': False,
    'STATION_STALE_PERIOD': 60 * 60 * 24 * 1,
    'EPG_TW_PRODUCTION': 'https://services.timewarnercable.com',
    'EPG_TW_DEV': 'https://msb-eng.timewarnercable.com',
}
for _k, _v in SETTINGS_DEFAULTS.items():
    if not hasattr(settings, _k):
        setattr(settings, _k, _v)
