"""Command for getting status of epgfetch"""
from atxstyle import defaultsettings

defaultsettings.setup_default()
from . import models


def status_options():
    import argparse

    parser = argparse.ArgumentParser(description='Write current EPG data-feed status')
    parser.add_argument(
        '-o',
        '--output',
        metavar='FILE_PATH',
        default=models.DEFAULT_STATUS_PATH,
        help="Path into which to write the status (as a json structure)",
    )
    return parser


def main():
    options = status_options().parse_args()
    return models.write_status(options.output)
