"""Command to summarize a downloaded epg data-file"""
import logging, time, json, glob
from atxstyle import standardlog
log = logging.getLogger( __name__ )

def get_options():
    import argparse
    parser = argparse.ArgumentParser(description='Print summary of epg data-file')
    parser.add_argument( 
        '-f','--files',
        default='/var/firmware/protected/epg/*/epg.json',
        help="EPG Data-file to process" 
    )
    return parser

def main():
    options = get_options().parse_args( )
    standardlog.enable()
    
    for path in glob.glob( options.files ):
        log.info("Checking: %s",path)
        content = json.loads( open(path).read())
        schedules = content.get('schedules',[])
        if schedules:
            schedule_count = len(schedules)
            start_dates = [s[2] for s in schedules]
            min_date,max_date = (
                time.localtime(min(start_dates)),
                time.localtime(max(start_dates)),
            )
            schedule_stations = set([s[0] for s in schedules])
            format = '%Y-%m-%d %H:%M'
            log.info("%s schedules in %s stations",schedule_count,len(schedule_stations))
            log.info("  Dates %s to %s", time.strftime(format,min_date),time.strftime(format,max_date))
            stations = set([s[0] for s in content.get('stations',[])])
            if len(stations) < len(schedule_stations):
                missing = stations-schedule_stations
                log.warning("%s stations have no data",len(missing))
                log.info("  missing schedules for tmsids: %s", ", ".join(sorted(missing)))
        else:
            log.error("No schedules present!")

if __name__ == "__main__":
    main()
